<?php
require_once __DIR__.'/../app/db.php';
require_once __DIR__.'/../app/helpers.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') { header('Location: index.php'); exit; }

$product_id = (int)($_POST['product_id'] ?? 0);
$quantity = max(1,(int)($_POST['quantity'] ?? 1));
$payment_method = $_POST['payment_method'] ?? 'Kapıda Nakit';
$first = trim($_POST['first_name'] ?? '');
$last = trim($_POST['last_name'] ?? '');
$phone = trim($_POST['phone'] ?? '');
$city = trim($_POST['city'] ?? '');
$district = trim($_POST['district'] ?? '');
$address = trim($_POST['address'] ?? '');
$note = trim($_POST['note'] ?? '');

$stmt = $pdo->prepare("SELECT price FROM products WHERE id=? AND active=1");
$stmt->execute([$product_id]);
$prod = $stmt->fetch();
if(!$prod){ die('Ürün bulunamadı.'); }
$total = $prod['price'] * $quantity;

$stmt = $pdo->prepare("INSERT INTO orders (product_id, quantity, payment_method, first_name, last_name, phone, city, district, address, note, total_amount) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
$stmt->execute([$product_id,$quantity,$payment_method,$first,$last,$phone,$city,$district,$address,$note,$total]);

$order_id = $pdo->lastInsertId();
?>
<!doctype html>
<html lang="tr">
<head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="stylesheet" href="assets/style.css">
<title>Sipariş Alındı</title>
</head>
<body class="container">
  <div class="card success">
    <h3>Teşekkürler! Siparişiniz alındı.</h3>
    <p>Sipariş No: #<?php echo (int)$order_id; ?> • Tutar: <?php echo money_tr($total); ?></p>
    <a class="cta" href="index.php">Anasayfaya dön</a>
  </div>
</body></html>
