<?php
require_once __DIR__.'/../app/db.php';
require_once __DIR__.'/../app/helpers.php';

$settings = $pdo->query("SELECT * FROM settings WHERE id=1")->fetch();
$cats = $pdo->query("SELECT * FROM categories WHERE active=1 ORDER BY name")->fetchAll();
$products = $pdo->query("SELECT p.*, c.name as cat_name FROM products p JOIN categories c ON c.id=p.category_id WHERE p.active=1 ORDER BY p.sort_order, p.id")->fetchAll();
?>
<!doctype html>
<html lang="tr">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title><?php echo h($settings['site_name']); ?></title>
<link rel="stylesheet" href="assets/style.css">
</head>
<body>
<header class="header">
  <div class="container inner">
    <div class="brand"><?php echo h($settings['site_name']); ?></div>
    <a href="#order" class="cta"><?php echo h($settings['hero_cta']); ?></a>
  </div>
</header>

<section class="hero">
  <div class="container">
    <h1><?php echo h($settings['hero_title']); ?></h1>
    <p class="small">Basit tek-sayfa sipariş formu. İçeriği admin panelinden yönetin.</p>
    <a class="cta" href="#order"><?php echo h($settings['hero_cta']); ?></a>
  </div>
</section>

<main class="container">
  <div class="grid" id="order">
    <div class="card">
      <h3>SİPARİŞ FORMU</h3>
      <form method="post" action="order_submit.php" id="orderForm">
        <label>Kategori</label>
        <select name="category_id" id="category">
          <?php foreach($cats as $c): ?>
            <option value="<?php echo (int)$c['id']; ?>"><?php echo h($c['name']); ?></option>
          <?php endforeach; ?>
        </select>

        <label>Ürün</label>
        <select name="product_id" id="product"></select>

        <div class="grid">
          <div>
            <label>Ödeme Şekli</label>
            <select name="payment_method" required>
              <option>Kapıda Nakit</option>
              <option>Kapıda Kredi Kartı</option>
            </select>
          </div>
          <div>
            <label>Adet</label>
            <input type="number" name="quantity" value="1" min="1" required>
          </div>
        </div>

        <div class="grid">
          <div>
            <label>Adınız</label>
            <input name="first_name" required>
          </div>
          <div>
            <label>Soyadınız</label>
            <input name="last_name" required>
          </div>
        </div>

        <label>Telefon</label>
        <input name="phone" required>

        <div class="grid">
          <div>
            <label>İl</label>
            <select name="city" id="city" required></select>
          </div>
          <div>
            <label>İlçe</label>
            <select name="district" id="district" required></select>
          </div>
        </div>

        <label>Adres</label>
        <textarea name="address" rows="3" required></textarea>

        <label>Notunuz</label>
        <textarea name="note" rows="2"></textarea>

        <label><input type="checkbox" required> Mesafeli Satış Sözleşmesi'ni okudum ve kabul ediyorum.</label>

        <button type="submit">SİPARİŞ VER</button>
        <p id="priceInfo" class="small"></p>
      </form>
    </div>
    <div>
      <?php foreach($products as $p): ?>
        <div class="card">
          <div class="badge"><?php echo h($p['cat_name']); ?></div>
          <h4><?php echo h($p['title']); ?></h4>
          <?php if($p['image']): ?><img src="<?php echo h($p['image']); ?>" alt="Ürün"><?php endif; ?>
          <?php if($p['description']): ?><p><?php echo nl2br(h($p['description'])); ?></p><?php endif; ?>
          <strong><?php echo money_tr($p['price']); ?></strong>
        </div>
      <?php endforeach; ?>
    </div>
  </div>

  <div class="card">
    <h3>Mesafe Sözleşmesi</h3>
    <div class="small">
      <?php echo nl2br(h($settings['contract_text'] ?? 'Admin panelinden sözleşme metnini düzenleyin.')); ?>
    </div>
  </div>
</main>

<footer class="footer">
  <div class="container">© <?php echo date('Y'); ?> <?php echo h($settings['company_name']); ?> • <a href="/admin/login.php">Yönetim</a></div>
</footer>

<script>
const PRODUCTS = <?php
  $byCat = [];
  foreach($products as $p){ $byCat[$p['category_id']][] = ['id'=>$p['id'],'title'=>$p['title'],'price'=>$p['price']]; }
  echo json_encode($byCat, JSON_UNESCAPED_UNICODE);
?>;
const CITIES = <?php echo file_get_contents(__DIR__.'/data/cities.json'); ?>;
const DISTRICTS = <?php echo file_get_contents(__DIR__.'/data/districts.json'); ?>;

const category = document.getElementById('category');
const productSel = document.getElementById('product');
const priceInfo = document.getElementById('priceInfo');
const citySel = document.getElementById('city');
const districtSel = document.getElementById('district');

function renderProducts(){
  const list = PRODUCTS[category.value] || [];
  productSel.innerHTML = list.map(p => `<option value="${p.id}" data-price="${p.price}">${p.title}</option>`).join('');
  updatePrice();
}
function updatePrice(){
  const opt = productSel.options[productSel.selectedIndex];
  if(!opt) { priceInfo.textContent=''; return; }
  priceInfo.textContent = 'Seçilen ürün: ' + opt.text + ' • Fiyat: ' + Number(opt.dataset.price).toLocaleString('tr-TR') + ' TL';
}
function renderCities(){
  citySel.innerHTML = CITIES.map(c => `<option>${c}</option>`).join('');
  renderDistricts();
}
function renderDistricts(){
  const c = citySel.value;
  const list = DISTRICTS[c] || [];
  districtSel.innerHTML = list.map(d => `<option>${d}</option>`).join('');
}

category.addEventListener('change', renderProducts);
productSel.addEventListener('change', updatePrice);
citySel.addEventListener('change', renderDistricts);

renderProducts();
renderCities();
</script>
</body>
</html>
