-- MySQL 5.7+/MariaDB 10+
CREATE DATABASE IF NOT EXISTS tek_urun_satis CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE tek_urun_satis;

-- Users (admin only for now)
CREATE TABLE IF NOT EXISTS users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  email VARCHAR(190) UNIQUE NOT NULL,
  password_hash VARCHAR(255) NOT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT IGNORE INTO users (email, password_hash)
VALUES ('admin@example.com', SHA2('AdminPass123', 256));

-- Settings (firma bilgileri, ödeme seçenekleri, sözleşme metinleri vs.)
CREATE TABLE IF NOT EXISTS settings (
  id INT PRIMARY KEY DEFAULT 1,
  site_name VARCHAR(190) NOT NULL DEFAULT 'Mağaza',
  company_name VARCHAR(190) DEFAULT 'FİRMA ADI',
  company_address VARCHAR(255) DEFAULT 'Adres bilgisi',
  company_phone VARCHAR(50) DEFAULT '+90 5xx xxx xx xx',
  company_email VARCHAR(190) DEFAULT 'info@example.com',
  hero_title VARCHAR(255) DEFAULT 'Tek Model Saat',
  hero_cta VARCHAR(120) DEFAULT 'Hemen Satın Al',
  contract_text MEDIUMTEXT NULL
);
INSERT IGNORE INTO settings (id) VALUES (1);

-- Categories
CREATE TABLE IF NOT EXISTS categories (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(190) NOT NULL,
  active TINYINT(1) DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO categories (name, active) VALUES ('Kategorisiz',1);

-- Products (varyant gibi kullanılabilir: adet=1,2... veya farklı paketler)
CREATE TABLE IF NOT EXISTS products (
  id INT AUTO_INCREMENT PRIMARY KEY,
  category_id INT NOT NULL,
  title VARCHAR(190) NOT NULL,
  description TEXT NULL,
  price DECIMAL(10,2) NOT NULL,
  compare_price DECIMAL(10,2) NULL,
  image VARCHAR(255) NULL,
  active TINYINT(1) DEFAULT 1,
  sort_order INT DEFAULT 0,
  FOREIGN KEY (category_id) REFERENCES categories(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO products (category_id,title,description,price,compare_price,image,active,sort_order) VALUES
(1,'EŞREF TEK MODEL SAAT - 1 ADET','Sınırlı sayıda.',999.00,NULL,NULL,1,1),
(1,'EŞREF TEK MODEL SAAT - 2 ADET','Favori seçim.',1599.00,NULL,NULL,1,2);

-- Orders
CREATE TABLE IF NOT EXISTS orders (
  id INT AUTO_INCREMENT PRIMARY KEY,
  product_id INT NOT NULL,
  quantity INT NOT NULL DEFAULT 1,
  payment_method ENUM('Kapıda Nakit','Kapıda Kredi Kartı') NOT NULL,
  first_name VARCHAR(100) NOT NULL,
  last_name VARCHAR(100) NOT NULL,
  phone VARCHAR(30) NOT NULL,
  city VARCHAR(100) NOT NULL,
  district VARCHAR(100) NOT NULL,
  address TEXT NOT NULL,
  note TEXT NULL,
  total_amount DECIMAL(10,2) NOT NULL,
  status ENUM('Yeni','Hazırlanıyor','Kargoda','Teslim','İptal') DEFAULT 'Yeni',
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (product_id) REFERENCES products(id) ON DELETE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
