<?php require_once __DIR__.'/_layout_header.php'; require_once __DIR__.'/../app/db.php'; require_once __DIR__.'/../app/helpers.php';

if($_SERVER['REQUEST_METHOD']==='POST'){
  if(isset($_POST['create'])){
    $stmt=$pdo->prepare("INSERT INTO products (category_id,title,description,price,compare_price,image,active,sort_order) VALUES (?,?,?,?,?,?,?,?)");
    $stmt->execute([$_POST['category_id'],$_POST['title'],$_POST['description'],$_POST['price']?:0,$_POST['compare_price']?:NULL,$_POST['image']?:NULL,isset($_POST['active'])?1:0,$_POST['sort_order']?:0]);
  } elseif(isset($_POST['update'])){
    $stmt=$pdo->prepare("UPDATE products SET category_id=?, title=?, description=?, price=?, compare_price=?, image=?, active=?, sort_order=? WHERE id=?");
    $stmt->execute([$_POST['category_id'],$_POST['title'],$_POST['description'],$_POST['price']?:0,$_POST['compare_price']?:NULL,$_POST['image']?:NULL,isset($_POST['active'])?1:0,$_POST['sort_order']?:0,(int)$_POST['id']]);
  } elseif(isset($_POST['delete'])){
    $stmt=$pdo->prepare("DELETE FROM products WHERE id=?");
    $stmt->execute([(int)$_POST['id']]);
  }
  header('Location: products.php'); exit;
}

$cats=$pdo->query("SELECT * FROM categories ORDER BY name")->fetchAll();
$items=$pdo->query("SELECT p.*, c.name cat FROM products p JOIN categories c ON c.id=p.category_id ORDER BY p.sort_order,p.id")->fetchAll();
?>
<h3>Ürünler</h3>
<div class="grid">
  <div class="card">
    <form method="post">
      <h4>Yeni Ürün</h4>
      <label>Kategori</label>
      <select name="category_id">
        <?php foreach($cats as $c): ?><option value="<?php echo (int)$c['id']; ?>"><?php echo h($c['name']); ?></option><?php endforeach; ?>
      </select>
      <label>Başlık</label><input name="title" required>
      <label>Açıklama</label><textarea name="description" rows="3"></textarea>
      <div class="grid">
        <div><label>Fiyat</label><input name="price" type="number" step="0.01" required></div>
        <div><label>Kıyas Fiyat</label><input name="compare_price" type="number" step="0.01"></div>
      </div>
      <label>Görsel URL</label><input name="image" placeholder="https://...">
      <div class="grid">
        <div><label>Sıra</label><input name="sort_order" type="number" value="0"></div>
        <div><label><input type="checkbox" name="active" checked> Aktif</label></div>
      </div>
      <button name="create" value="1">Ekle</button>
    </form>
  </div>
  <div class="card">
    <table class="table">
      <tr><th>ID</th><th>Başlık</th><th>Kategori</th><th>Fiyat</th><th>Aktif</th><th>İşlem</th></tr>
      <?php foreach($items as $it): ?>
      <tr>
        <td><?php echo (int)$it['id']; ?></td>
        <td><?php echo h($it['title']); ?></td>
        <td><?php echo h($it['cat']); ?></td>
        <td><?php echo money_tr($it['price']); ?></td>
        <td><?php echo $it['active']?'Evet':'Hayır'; ?></td>
        <td>
          <form method="post" style="display:grid;grid-template-columns:repeat(7,1fr);gap:8px;align-items:center">
            <input type="hidden" name="id" value="<?php echo (int)$it['id']; ?>">
            <select name="category_id">
              <?php foreach($cats as $c): ?><option value="<?php echo (int)$c['id']; ?>" <?php echo $c['id']==$it['category_id']?'selected':''; ?>><?php echo h($c['name']); ?></option><?php endforeach; ?>
            </select>
            <input name="title" value="<?php echo h($it['title']); ?>">
            <input name="price" type="number" step="0.01" value="<?php echo h($it['price']); ?>">
            <input name="compare_price" type="number" step="0.01" value="<?php echo h($it['compare_price']); ?>">
            <input name="image" value="<?php echo h($it['image']); ?>">
            <label class="small"><input type="checkbox" name="active" <?php echo $it['active']?'checked':''; ?>> Aktif</label>
            <input name="sort_order" type="number" value="<?php echo (int)$it['sort_order']; ?>">
            <textarea name="description" rows="1"><?php echo h($it['description']); ?></textarea>
            <button name="update" value="1">Kaydet</button>
            <button name="delete" value="1" onclick="return confirm('Silinsin mi?')">Sil</button>
          </form>
        </td>
      </tr>
      <?php endforeach; ?>
    </table>
  </div>
</div>
<?php require_once __DIR__.'/_layout_footer.php'; ?>
