<?php require_once __DIR__.'/_layout_header.php'; require_once __DIR__.'/../app/db.php'; require_once __DIR__.'/../app/helpers.php';

if($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['id'])){
  $stmt=$pdo->prepare("UPDATE orders SET status=? WHERE id=?");
  $stmt->execute([$_POST['status'], (int)$_POST['id']]);
  header('Location: orders.php'); exit;
}
$items=$pdo->query("SELECT o.*, p.title product FROM orders o JOIN products p ON p.id=o.product_id ORDER BY o.id DESC")->fetchAll();
?>
<h3>Siparişler</h3>
<table class="table">
  <tr><th>#</th><th>Ürün</th><th>Ad Soyad</th><th>Telefon</th><th>Adres</th><th>Tutar</th><th>Durum</th><th>Tarih</th></tr>
  <?php foreach($items as $it): ?>
  <tr>
    <td><?php echo (int)$it['id']; ?></td>
    <td><?php echo h($it['product']); ?> x<?php echo (int)$it['quantity']; ?><div class="small"><?php echo h($it['payment_method']); ?></div></td>
    <td><?php echo h($it['first_name'].' '.$it['last_name']); ?></td>
    <td><a href="https://wa.me/<?php echo preg_replace('/\D/','',$it['phone']); ?>" target="_blank"><?php echo h($it['phone']); ?></a></td>
    <td class="small"><?php echo h($it['city'].' / '.$it['district']); ?><br><?php echo nl2br(h($it['address'])); ?></td>
    <td><?php echo money_tr($it['total_amount']); ?></td>
    <td>
      <form method="post">
        <input type="hidden" name="id" value="<?php echo (int)$it['id']; ?>">
        <select name="status" onchange="this.form.submit()">
          <?php foreach(['Yeni','Hazırlanıyor','Kargoda','Teslim','İptal'] as $s): ?>
            <option <?php echo $it['status']===$s?'selected':''; ?>><?php echo $s; ?></option>
          <?php endforeach; ?>
        </select>
      </form>
    </td>
    <td class="small"><?php echo h($it['created_at']); ?></td>
  </tr>
  <?php endforeach; ?>
</table>
<?php require_once __DIR__.'/_layout_footer.php'; ?>
