<?php require_once __DIR__.'/_layout_header.php'; require_once __DIR__.'/../app/db.php'; require_once __DIR__.'/../app/helpers.php';

if($_SERVER['REQUEST_METHOD']==='POST'){
  if(isset($_POST['create'])){
    $stmt=$pdo->prepare("INSERT INTO categories (name,active) VALUES (?,?)");
    $stmt->execute([$_POST['name'], isset($_POST['active'])?1:0]);
  } elseif(isset($_POST['update'])){
    $stmt=$pdo->prepare("UPDATE categories SET name=?, active=? WHERE id=?");
    $stmt->execute([$_POST['name'], isset($_POST['active'])?1:0, (int)$_POST['id']]);
  } elseif(isset($_POST['delete'])){
    $stmt=$pdo->prepare("DELETE FROM categories WHERE id=?");
    $stmt->execute([(int)$_POST['id']]);
  }
  header('Location: categories.php'); exit;
}

$items=$pdo->query("SELECT * FROM categories ORDER BY name")->fetchAll();
?>
<h3>Kategoriler</h3>
<div class="grid">
  <div class="card">
    <form method="post">
      <h4>Yeni Kategori</h4>
      <label>Ad</label><input name="name" required>
      <label><input type="checkbox" name="active" checked> Aktif</label>
      <button name="create" value="1">Ekle</button>
    </form>
  </div>
  <div class="card">
    <table class="table">
      <tr><th>ID</th><th>Ad</th><th>Aktif</th><th>İşlem</th></tr>
      <?php foreach($items as $it): ?>
        <tr>
          <td><?php echo (int)$it['id']; ?></td>
          <td><?php echo h($it['name']); ?></td>
          <td><?php echo $it['active']?'Evet':'Hayır'; ?></td>
          <td>
            <form method="post" style="display:inline-flex;gap:8px;align-items:center">
              <input type="hidden" name="id" value="<?php echo (int)$it['id']; ?>">
              <input name="name" value="<?php echo h($it['name']); ?>">
              <label class="small"><input type="checkbox" name="active" <?php echo $it['active']?'checked':''; ?>> Aktif</label>
              <button name="update" value="1">Kaydet</button>
              <button name="delete" value="1" onclick="return confirm('Silinsin mi?')">Sil</button>
            </form>
          </td>
        </tr>
      <?php endforeach; ?>
    </table>
  </div>
</div>
<?php require_once __DIR__.'/_layout_footer.php'; ?>
